function [f2,Amp2,Pha2]=bode5NM
%clear 
%close all
load('bode_data_5_nm_100hz_0223');

Ts=0;
Tn=84.5;
p_s=Ts*2000+1;
p_n=Tn*2000;
t=1:1:p_n-p_s+1;
t=t/2000;

Fe2=Extention_F_Data(p_s:p_n);
Ff2=Flexion_F_Data(p_s:p_n);
Tac2=(Fe2-Ff2)*0.031*8;
Ta2=Actual_F_Data(p_s:p_n);
Td2=Desired_F_Data(p_s:p_n);
Ta2=Ta2*0.031*8;
Td2=Td2*0.031*8;

figure1 = figure;
axes1 = axes('Parent',figure1);
hold(axes1,'on');
box(axes1,'on');
set(axes1,'FontSize',12);
plot(t,Td2,'Color',[0 0 0],'LineWidth',0.5);
hold on
plot(t,Ta2,'Color',[0.5 0.5 0.5],'LineWidth',0.5);
xlabel('Time(s)','FontSize',12);
ylabel('Torque(Nm)','FontSize',12);
xlim([0 Tn-Ts]);
ylim([-15 15]);
legend1=legend('Desired Torque (Nm)','Actual Torque (Nm)');
set(legend1,'FontSize',12);
%Bode
Fs=2000;
Ftest=100;
[f2,Amp2,Pha2]=bode_cal(Td2,Ta2,Fs,Ftest);
figure2 = figure;
subplot1 = subplot(2,1,1,'Parent',figure2);
semilogx(f2,Amp2,'Parent',subplot1,'Color',[0 0 0],'LineWidth',2);
xlabel('Frequency(Hz)','FontSize',12);
ylabel('Magnitude(dB)','FontSize',12);
box(subplot1,'on');
set(subplot1,'FontSize',12,'XMinorTick','on','XScale','log');
legend('Torque Control');
subplot2 = subplot(2,1,2,'Parent',figure2);
hold(subplot2,'on');
semilogx(f2,Pha2,'Parent',subplot2,'Color',[0 0 0],'LineWidth',2);
xlabel('Frequency(Hz)','FontSize',12);
ylabel('Phase(Degree)','FontSize',12);
box(subplot2,'on');
set(subplot2,'FontSize',12,'XMinorTick','on','XScale','log');
legend('Torque Control');